#!/usr/bin/perl -w
#
#  crypt.cgi - Demonstration of Perl's crypt()
#  Copyright (c) 1999 Ha Quach, ha@linux1.org
#  Written for www.irt.org
#
#  Smack it, hack it, learn it, burn it. No warranties whatsoever,
#  although tested for Windows NT 4.0 and Linux 2.2.
#
#  This program is distributed under the same terms as Perl itself.
#  Please keep copyright header intact.
#
#######################################################################


use strict;                      # Be nice!
$| = 1;                          # Flush Perl's output buffer.
binmode(STDIN);                  # For CR/LF to \n for Win32.
binmode(STDOUT);
binmode(STDERR);
my %in = &parse_query_string;    # Stuff name-values into a hash.



# This is the main stuff. Everything else is in routines. First, let's
# tell the Web browser what we're doing.

print "Content-type: text/html\n\n";



# Start up the HTML page.

print qq|<html>
<head>
   <title>Demo1: Perl's Built-in crypt() function</title>
</head>
<body bgcolor="white">\n\n
<h1>Demo: Perl's Built-in <tt>crypt()</tt> Function</h1>|;



# If we have user input, print the encrypted string. Proceed with form
# no matter what. Let's not mangle up the user's password since we might
# have to go through both the UNIX and the Win32 routines.

if(($in{'unix'}  || $in{'win'}) && $in{'pass'}) {
   my $pass_unix   = &encrypt_password ($in{'pass'}) if $in{'unix'};
   my $pass_win    = $in{'pass'};
      $in{'int'}   = 13 unless $in{'int'} =~ /\d/;
   for(0..$in{'int'}) {
      $pass_win = &encrypt_password_Win32($pass_win);
   }
    
   print qq|
Hit RELOAD on your browser and...
<pre>
   $in{'pass'} -&gt; UNIX  (&encrypt_string)       -> <b>$pass_unix</b>
   ... notice how the same password yields a different encrypted string!

   $in{'pass'} -&gt; WIN32 (&encrypt_string_Win32) -> $pass_win
   ... notice why Win32 is notoriously IN-secure :-(
</pre>
<hr size=3 noshade><br><br>\n\n|;
}



## Back to the HTML

print qq|
<form method=post action="$ENV{'SCRIPT_NAME'}">
Enter some text below and check whether you want to see it run through
the UNIX routine and/or the Win32 routine. The encrypted string will be
displayed at the top of the page. For the purpose of this demo, you'll
see your string. Normally you would want to use the <tt>input
type=password</tt> form property instead.<br><br>

<input type=text     name="pass" size=30><br>
<input type=checkbox name="unix"> UNIX <tt>&encrypt_password</tt><br>
<input type=checkbox name="win"> Win32 <tt>&encrypt_password_Win32</tt><br><br>
If Win32, enter an integer from 1 to 9 here
<input type=text name="int" size=2 maxlength=1>
for the number of recursions (default=13).<br><br>
<input type=submit   value="See crypt() in action">
<input type=reset    value="clear">
</form>

</body>
</html>|;




## We're outta here!
exit;




# END main program. START subroutines.
# =====================================================================
sub parse_query_string
{  # This is a cheap and cheesey CGI parser because I refuse to use
   # cgi-lib.pl or, heaven forbids, CGI.pm. Note that names with
   # multiple values are delimited by a tab, which you'll need to
   # split() into an array if you want to get at the values.

   my($buffer,$name,$value);
   my @pairs = ();
   my %FORM  = ();
   
   $ENV{'REQUEST_METHOD'} =~ tr/a-z/A-Z/;
   if ($ENV{'REQUEST_METHOD'} eq "POST") {
      read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
   }
	else { 
	   $buffer = $ENV{'QUERY_STRING'};
	}
   @pairs = split(/&/, $buffer);
   foreach(@pairs) {
      ($name, $value) = split (/=/, $_);
      $value          =~ tr/+/ /;
      $value          =~ s/%(..)/pack("C", hex($1))/eg;
      $FORM{$name}   .= "\t" if $FORM{$name};
      $FORM{$name}   .= $value;
   }
   %FORM;
}

sub encrypt_password
{
   my $unencrypted_string = shift @_;
   my @salt_chars         = ('a'..'z','A'..'Z','0'..'9');
   my $salt               = $salt_chars[rand(63)] . $salt_chars[rand(63)];
   return crypt($unencrypted_string, $salt);
}

sub encrypt_password_Win32
{  # Do not try loops here. You'll get deep recursion.

   my $unencrypted_string = shift @_;
   my($unencrypted_salt,$first_crypt,$encrypted_salt,$encrypted_string);
      $unencrypted_salt    = 'tomorrow';
      $first_crypt         = crypt($unencrypted_string,$unencrypted_salt);
      $encrypted_salt      = substr($first_crypt,3,1).substr($first_crypt,7,1);
      $encrypted_string    = crypt($unencrypted_string,$encrypted_salt);

   return crypt($encrypted_string,$encrypted_salt);
}
